/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.network;

import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ToggleMessage {
    public static ToggleMessage decode(FriendlyByteBuf buffer) {
        buffer.readByte();
        return new ToggleMessage();
    }

    public static void encode(ToggleMessage message, FriendlyByteBuf buffer) {
        buffer.writeByte(0);
    }

    public static void handle(ToggleMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack backpack = BackpackUtils.findBackpackForHotkeys((Player)player, true);
            BackpackItem.togglePickup((Player)player, backpack);
        });
        ctx.get().setPacketHandled(true);
    }
}

